define(['jquery'], function($) {
  // VELOCITY
  var PAGE_CONTENT = "<div class=\"box infomessage\"><p>This page contains code for notifying the user when an error occurs in a Realtime Editor.<\/p><\/div><div class=\"hidden\"><div class=\"realtime-error\"><h1 id=\"HOops2Csomethingwentwrong21\" class=\"wikigeneratedid\"><span>Oops, something went wrong!<\/span><\/h1><p>The Realtime Editor has encountered a non-recoverable error and must stop.<br\/>Some of your work may not be saved but it is below and you may save it now and re-integrate it into the Realtime session.<\/p><textarea class=\"realtime-content\" cols=\"60\" rows=\"10\"><\/textarea><p>Please consider <span class=\"wikiexternallink\"><a href=\"https:\/\/jira.xwiki.org\/browse\/XWIKI\">reporting a bug<\/a><\/span>, including the following content (Privacy note: This contains the history of the document you were working on).<\/p><textarea class=\"realtime-debug\" cols=\"60\" rows=\"10\"><\/textarea><\/div><div class=\"realtime-disconnected\"><h1 id=\"HDisconnected\" class=\"wikigeneratedid\"><span>Disconnected<\/span><\/h1><p>Your connection to the Realtime Editor has been lost, you may try refreshing the page to get the connection back but some of your most recent work may be lost. To return to the page and continue in <strong>non<\/strong> realtime mode, simply close this box.<\/p><\/div><div class=\"realtime-unavailable\"><h1 id=\"HUnavailable\" class=\"wikigeneratedid\"><span>Unavailable<\/span><\/h1><p>The Realtime Editor's back-end does not seem to be available. You can reload the page and attempt to reconnect, or close this box and continue in <strong>non<\/strong> realtime mode.<\/p><\/div><div class=\"realtime-debuglog\"><hr>\nPlease consider [[reporting a bug>>https:\/\/jira.xwiki.org\/browse\/XWIKI||target=\"_blank\" rel=\"noopener noreferrer\"]], including the following content.<br>\n<b>Privacy note<\/b>: This contains data about the document you were working on, including its content.\n<textarea class=\"realtime-debug\" cols=\"60\" rows=\"4\"><\/textarea><\/div><div class=\"realtime-merge\"><h1 id=\"HMergeError\" class=\"wikigeneratedid\"><span>Merge Error<\/span><\/h1><p>It looks like someone saved this document outside of the realtime session, and we were unable to merge your work with theirs.<\/p><\/div><div class=\"realtime-parse\"><h1 id=\"HParseError\" class=\"wikigeneratedid\"><span>Parse Error<\/span><\/h1><p>We were unable to parse the server's response.<\/p><\/div><div class=\"realtime-save\"><h1 id=\"HSaveError\" class=\"wikigeneratedid\"><span>Save Error<\/span><\/h1><p>We were unable to save your document. Try again shortly.<br\/>If this message is displayed everytime you try to save the document, you should consider <strong>disabling the realtime engine<\/strong> (uncheck the \"Allow Realtime Collaboration\" checkbox) and <strong>save<\/strong> again.<\/p><\/div><div class=\"realtime-velocity\"><h1 id=\"HCriticalSaveError\" class=\"wikigeneratedid\"><span>Critical Save Error<\/span><\/h1><p>The realtime saver\/merger script has encountered an unexpected error and <strong>the save was not performed<\/strong>.<br\/>If this message is displayed everytime you try to save the document, you should consider <strong>disabling the realtime engine<\/strong> (uncheck the \"Allow Realtime Collaboration\" checkbox) and <strong>save<\/strong> again.<\/p><\/div><div class=\"realtime-updateversion\"><h1 id=\"HUpdateversionerror\" class=\"wikigeneratedid\"><span>Update version error<\/span><\/h1><p>We were unable to update the version of the document, which could create important merge error and loss of content.<br\/>To avoid that, <strong>Realtime has been disabled<\/strong> and you are now editing this document <em>offline<\/em>.<\/p><\/div><div class=\"realtime-keepremote\"><h1 id=\"HMergeerror\" class=\"wikigeneratedid\"><span>Merge error<\/span><\/h1><p>We were unable to get the <strong>remote<\/strong> content into the realtime session.<br\/><strong>Realtime has been disabled<\/strong> so that you can fix the merge conflict manually <em>offline<\/em>.<\/p><\/div><div class=\"realtime-converthtml\"><h1 id=\"HWYSIWYGerror\" class=\"wikigeneratedid\"><span>WYSIWYG error<\/span><\/h1><p>We were unable to update the WYSIWYG editor with the merged content.<br\/><strong>Realtime has been disabled<\/strong> so that you can fix the merge manually.<\/p><\/div><\/div>";
  // END VELOCITY

  // FIXME: Use Bootstrap modals instead.
  var ModalPopup = Class.create(XWiki.widgets.ModalPopup, {
    initialize: function($super, interactionParameters) {
      this.interactionParameters = $.extend({}, interactionParameters);
      $super(this.createContent(this.interactionParameters), {
        show: {method: this.showDialog, keys: []},
        close: {method: this.closeDialog, keys: ['Esc']}
      }, {
        displayCloseButton : true,
        verticalPosition : 'top',
        backgroundColor : '#FFF'
      });
      this.showDialog();
    },

    createContent: function (data) {
      var modalContent = $('<div class="modal-popup"/>');
      setTimeout(function() {
        data.then(modalContent[0]);
      }, 0);
      return modalContent[0];
    }
  });

  var errorMessages = {};
  // FIXME: Load the error messages in a separate request instead of including them in the JavaScript code (which
  // prevents the code from being cached and also creates problems if we want to translate the error messages).
  $('<div/>').html(PAGE_CONTENT).find('div.hidden > div[class^="realtime-"]').each(function() {
    errorMessages[this.className.substring('realtime-'.length)] = this;
  });

  var modal;
  var show = function(errorType, debugLog) {
    modal = new ModalPopup({then: function(modalContent) {
      var errorMessage = errorMessages[errorType] || document.createTextNode(`error of unknown type [${errorType}]`);
      $(modalContent).append(errorMessage);
      if (debugLog) {
        $(modalContent).append(errorMessages['debuglog']).find('.realtime-debug').val(debugLog);
      }
    }});
  };

  var hide = function() {
    return modal && modal.closeDialog();
  };

  return {show, hide};
});
